import numpy as np
import pandas as pd
import statsmodels.formula.api as sm
import matplotlib.pyplot as plt
from sklearn.metrics import mean_squared_error
from pathlib import Path
from sklearn.neural_network import MLPRegressor

filepath = Path('folder/subfolder/out.csv')
filepath.parent.mkdir(parents=True, exist_ok=True)
mill = pd.read_feather("feather.feather")
scenario = mill.columns[1:7]
measure = mill.columns.symmetric_difference(scenario)
X = mill.columns.symmetric_difference(["VB", "RUL", "case"])
f = "VB ~ " + ' + '.join([col for col in X])

result = pd.DataFrame(columns=['iteration', 'method', 'rmse', 'rrse'])
performance = pd.DataFrame(columns=['method', 'meanRMSE', 'meanRRSE'])
error = pd.DataFrame(columns=['iteration', 'case', 'run', 'Taylor', 'NN'])

mill = mill[(mill.case != 1)]

case = mill[['case', 'DOC', 'feed', 'material1']].drop_duplicates()
case_m1 = case[case['material1'] == 1]
case_m2 = case[case['material1'] == 0]
n_case_train_for_m = 6


plt.boxplot(mill.VB)

plt.xlabel("VB")
plt.ylabel("run")
plt.legend()
plt.title('multiple plots')
plt.show()
